//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3

import wesual.Controls 1.0

Item {
    id : dropIndicator

    property bool horizontal : false

    z : 100
    visible : false
    opacity : 0

    Behavior on x {
        enabled : dropIndicator.visible
        SmoothedAnimation {
            duration: 200
        }
    }
    Behavior on y {
        enabled : dropIndicator.visible
        SmoothedAnimation {
            duration: 200
        }
    }

    states : State {
        name : "visible"
        when : dropIndicator.visible

        PropertyChanges {
            target : dropIndicator
            opacity : 1
        }
    }

    transitions : [
        Transition {
            to : "visible"

            SequentialAnimation {
                PropertyAction {
                    target : dropIndicator
                    property : "opacity"
                    value : 0
                }
                PropertyAction {
                    target : dropIndicator
                    property : "visible"
                    value : true
                }
                NumberAnimation {
                    target : dropIndicator
                    duration : 200
                    property : "opacity"
                }
            }
        },
        Transition {
            from : "visible"

            SequentialAnimation {
                NumberAnimation {
                    target : dropIndicator
                    duration : 200
                    property : "opacity"
                }
                PropertyAction {
                    target : dropIndicator
                    property : "visible"
                    value : false
                }
            }
        }
    ]

    Rectangle {
        id : visual
        height : dropIndicator.horizontal ? 3 : dropIndicator.height
        width : dropIndicator.horizontal ? dropIndicator.width : 3
        anchors {
            horizontalCenter : parent.horizontalCenter
            top : parent.top
        }
        color : UI.color(UI.SecondaryHover)
    }
}
